USE [msdb]
GO

/****** Object:  Job [Index Overview]  ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object:  JobCategory [[Uncategorized (Local)]]]  ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'[Uncategorized (Local)]' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'[Uncategorized (Local)]'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'Index Overview', 
		@enabled=1, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'Run this job (change run in db at script level) for a database that you want to get an overview of index''s

This includes the following data pulls and subsequent reports:
Duplicate Index
Missing Index
Unused Index
Longest Queries
Fragmentation Levels
Index Read Counts
Index Read Statements', 
		@category_name=N'[Uncategorized (Local)]', 
		@owner_login_name=N'<add job owner name here>', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [clean up]     ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'clean up', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'--clean up

--clean up

USE SQL_Monitoring
go
Truncate Table dbo.IndexOverviewReadsWithCounts
go
Truncate Table dbo.IndexOverviewReadsWithQuery
go
Truncate Table dbo.IndexOverviewReadsWithCounts_stage 
go
Truncate Table dbo.IndexOverviewReadsWithQuery_stage

Truncate Table dbo.IndexOverview_DuplicateIndex
go
Truncate Table dbo.IndexOverview_FragLevels
go
Truncate Table dbo.IndexOverview_LongestQueries
go
Truncate Table dbo.IndexOverview_MissingIndex
go
Truncate Table dbo.IndexOverview_UnusedIndex
go
IF OBJECT_ID(''tempdb..##Duplicates'') IS NOT NULL
/*Then it exists*/
   DROP TABLE ##Duplicates

', 
		@database_name=N'DBA_Monitoring', 
		@output_file_name=N'<add your path>\IndexOverviewErrors.txt', 
		@flags=6
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [get the data]     ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'get the data', 
		@step_id=2, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'--get the data
--need to do this entire script for each db
-- change DB name above to collect from

Declare @DBName as varchar(100)
Set @DBName = ''<Add your db name to be monitored here>'' --add db name here to be checked 

--get longest running queries
INSERT INTO [DBA_Monitoring].[dbo].[IndexOverview_LongestQueries]
           ([ServerName]
           ,[DBName]
           ,[QueryName]
           ,[ExecutionCount]
           ,[MaxElapsedTime]
           ,[AvgElapsedTime]
           ,[LogCreatedOn])
(SELECT DISTINCT TOP 25 @@SERVERNAME as ServerName, @DBName as DBName,
t.TEXT QueryName,
s.execution_count AS ExecutionCount,
s.max_elapsed_time AS MaxElapsedTime,
ISNULL(s.total_elapsed_time / s.execution_count, 0) AS AvgElapsedTime,
s.creation_time AS LogCreatedOn
FROM sys.dm_exec_query_stats s
CROSS APPLY sys.dm_exec_sql_text( s.sql_handle ) t)

-- Unused Index Script
INSERT INTO [DBA_Monitoring].[dbo].[IndexOverview_UnusedIndex]
           ([ServerName]
           ,[DBName]
           ,[ObjectName]
           ,[IndexName]
           ,[IndexID]
           ,[UserSeek]
           ,[UserScans]
           ,[UserLookups]
           ,[UserUpdates]
           ,[TableRows]
           ,[drop statement])
(SELECT TOP 25 @@SERVERNAME as ServerName, @DBName as DBName, o.name AS ObjectName
, i.name AS IndexName
, i.index_id AS IndexID  
, dm_ius.user_seeks AS UserSeek
, dm_ius.user_scans AS UserScans
, dm_ius.user_lookups AS UserLookups
, dm_ius.user_updates AS UserUpdates
, p.TableRows
, ''DROP INDEX '' + QUOTENAME(i.name) 
+ '' ON '' + QUOTENAME(s.name) + ''.'' + QUOTENAME(OBJECT_NAME(dm_ius.object_id)) as ''drop statement''
FROM sys.dm_db_index_usage_stats dm_ius  
INNER JOIN sys.indexes i ON i.index_id = dm_ius.index_id AND dm_ius.object_id = i.object_id   
INNER JOIN sys.objects o on dm_ius.object_id = o.object_id
INNER JOIN sys.schemas s on o.schema_id = s.schema_id
INNER JOIN (SELECT SUM(p.rows) TableRows, p.index_id, p.object_id 
				
FROM sys.partitions p GROUP BY p.index_id, p.object_id) p 
		
ON p.index_id = dm_ius.index_id AND dm_ius.object_id = p.object_id

WHERE OBJECTPROPERTY(dm_ius.object_id,''IsUserTable'') = 1
AND dm_ius.database_id = DB_ID()   
AND i.type_desc = ''nonclustered''
AND i.is_primary_key = 0
AND i.is_unique_constraint = 0)


-- Missing Index Script
INSERT INTO [DBA_Monitoring].[dbo].[IndexOverview_MissingIndex]
           ([ServerName]
           ,[DBName]
           ,[DatabaseID]
           ,[Avg_Estimated_Impact]
           ,[Last_User_Seek]
           ,[TableName]
           ,[Create_Statement])
 (SELECT TOP 25 @@SERVERNAME as ServerName, @DBName as DBName,
dm_mid.database_id AS DatabaseID, 
dm_migs.avg_user_impact*(dm_migs.user_seeks+dm_migs.user_scans) Avg_Estimated_Impact,
dm_migs.last_user_seek AS Last_User_Seek,
object_name(dm_mid.object_id,dm_mid.database_id) AS [TableName],
''CREATE INDEX [IX_'' + object_name(dm_mid.object_id,dm_mid.database_id) + ''_''
+ REPLACE(REPLACE(REPLACE(ISNULL(dm_mid.equality_columns,''''),'', '',''_''),''['',''''),'']'','''') +
CASE
	WHEN dm_mid.equality_columns IS NOT NULL AND dm_mid.inequality_columns IS NOT NULL THEN ''_''
	ELSE ''''
END
+ REPLACE(REPLACE(REPLACE(ISNULL(dm_mid.inequality_columns,''''),'', '',''_''),''['',''''),'']'','''')
+ '']''
+ '' ON '' + dm_mid.statement
+ '' ('' + ISNULL (dm_mid.equality_columns,'''')
+ CASE WHEN dm_mid.equality_columns IS NOT NULL AND dm_mid.inequality_columns IS NOT NULL THEN '','' ELSE
'''' END
+ ISNULL (dm_mid.inequality_columns, '''')
+ '')''
+ ISNULL ('' INCLUDE ('' + dm_mid.included_columns + '')'', '''') AS Create_Statement
FROM sys.dm_db_missing_index_groups dm_mig
INNER JOIN sys.dm_db_missing_index_group_stats dm_migs
ON dm_migs.group_handle = dm_mig.index_group_handle
INNER JOIN sys.dm_db_missing_index_details dm_mid
ON dm_mig.index_handle = dm_mid.index_handle
WHERE dm_mid.database_ID = DB_ID())

---fragmentation levels
INSERT INTO [DBA_Monitoring].[dbo].[IndexOverview_FragLevels]
           ([ServerName]
           ,[DBName]
           ,[Table]
           ,[Index]
           ,[avg_fragmentation_in_percent]
           ,[page_count])
(SELECT @@SERVERNAME as ServerName, @DBName as DBName,
dbtables.[name] as ''Table'', 
dbindexes.[name] as ''Index'',
indexstats.avg_fragmentation_in_percent,
indexstats.page_count
FROM sys.dm_db_index_physical_stats (DB_ID(), NULL, NULL, NULL, NULL) AS indexstats
INNER JOIN sys.tables dbtables on dbtables.[object_id] = indexstats.[object_id]
INNER JOIN sys.schemas dbschemas on dbtables.[schema_id] = dbschemas.[schema_id]
INNER JOIN sys.indexes AS dbindexes ON dbindexes.[object_id] = indexstats.[object_id]
AND indexstats.index_id = dbindexes.index_id
WHERE indexstats.database_id = DB_ID())

GO
--USE DBA_Monitoring  --update to db name to run against
--go

--Duplicate Index
WITH MyDuplicate AS (SELECT 
	Obj.[name] AS TableName,
	Idx.[name] AS IndexName,
	INDEX_Col(Sch.[name] + ''.'' + Obj.[name], Idx.index_id, 1) AS Col1,
	INDEX_Col(Sch.[name] + ''.'' + Obj.[name], Idx.index_id, 2) AS Col2,
	INDEX_Col(Sch.[name] + ''.'' + Obj.[name], Idx.index_id, 3) AS Col3,
	INDEX_Col(Sch.[name] + ''.'' + Obj.[name], Idx.index_id, 4) AS Col4,
	INDEX_Col(Sch.[name] + ''.'' + Obj.[name], Idx.index_id, 5) AS Col5,
	INDEX_Col(Sch.[name] + ''.'' + Obj.[name], Idx.index_id, 6) AS Col6,
	INDEX_Col(Sch.[name] + ''.'' + Obj.[name], Idx.index_id, 7) AS Col7,
	INDEX_Col(Sch.[name] + ''.'' + Obj.[name], Idx.index_id, 8) AS Col8,
	INDEX_Col(Sch.[name] + ''.'' + Obj.[name], Idx.index_id, 9) AS Col9,
	INDEX_Col(Sch.[name] + ''.'' + Obj.[name], Idx.index_id, 10) AS Col10,	
FROM sys.indexes Idx
INNER JOIN sys.objects Obj ON Idx.[object_id] = Obj.[object_id]
INNER JOIN sys.schemas Sch ON Sch.[schema_id] = Obj.[schema_id]
WHERE index_id > 0)
SELECT	MD1.TableName, MD1.IndexName, 
		MD2.IndexName AS OverLappingIndex,
		MD1.Col1, MD1.Col2, MD1.Col3, MD1.Col4, 
		MD1.Col5, MD1.Col6, MD1.Col7, MD1.Col8, 
		MD1.Col9, MD1.Col10
INTO ##Duplicates
FROM MyDuplicate MD1
INNER JOIN MyDuplicate MD2 ON MD1.tablename = MD2.tablename
	AND MD1.indexname <> MD2.indexname
	AND MD1.Col1 = MD2.Col1
	AND (MD1.Col2 IS NULL OR MD2.Col2 IS NULL OR MD1.Col2 = MD2.Col2)
	AND (MD1.Col3 IS NULL OR MD2.Col3 IS NULL OR MD1.Col3 = MD2.Col3)
	AND (MD1.Col4 IS NULL OR MD2.Col4 IS NULL OR MD1.Col4 = MD2.Col4)
	AND (MD1.Col5 IS NULL OR MD2.Col5 IS NULL OR MD1.Col5 = MD2.Col5)
	AND (MD1.Col6 IS NULL OR MD2.Col6 IS NULL OR MD1.Col6 = MD2.Col6)
	AND (MD1.Col7 IS NULL OR MD2.Col7 IS NULL OR MD1.Col7 = MD2.Col7)
	AND (MD1.Col8 IS NULL OR MD2.Col8 IS NULL OR MD1.Col8 = MD2.Col8)
	AND (MD1.Col9 IS NULL OR MD2.Col9 IS NULL OR MD1.Col9 = MD2.Col9)
	AND (MD1.Col10 IS NULL OR MD2.Col10 IS NULL OR MD1.Col10 = MD2.Col10)
	
Declare @DBName as varchar(100)
Set @DBName = ''<add your database name here to monitor>'' --add db name here to be checked
	
INSERT INTO [DBA_Monitoring].[dbo].[IndexOverview_DuplicateIndex]
           (ServerName,
           DBName,
           [TableName]
           ,[IndexName]
           ,[OverLappingIndex]
           ,[Col1]
           ,[Col2]
           ,[Col3]
           ,[Col4]
           ,[Col5]
           ,[Col6]
           ,[Col7]
           ,[Col8]
           ,[Col9]
           ,[Col10]
           )
     (select @@ServerName, @DBName, [TableName]
           ,[IndexName]
           ,[OverLappingIndex]
           ,[Col1]
           ,[Col2]
           ,[Col3]
           ,[Col4]
           ,[Col5]
           ,[Col6]
           ,[Col7]
           ,[Col8]
           ,[Col9]
           ,[Col10]
            from ##Duplicates)', 
		@database_name=N'<add your database name to be monitored here>', 
		@output_file_name=N'<add your path>\IndexOverviewErrors.txt', 
		@flags=2
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [report - duplicate Index]      ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'report - duplicate Index', 
		@step_id=3, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject=''SQL Server - Index Overview_Duplicate Index ''''Add Server Name''''''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM DBA_Monitoring.dbo.IndexOverview_DuplicateIndex
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N''<table border="1">'' +
N''<tr>'' +
N''<th>Server Name</th>'' +
N''<th>DB Name</th>'' +
N''<th>Table Name</th>'' +
N''<th>Over Lapping Index</th>'' +
N''<th>Col1</th>'' +
N''<th>Col2</th>'' +
N''<th>Col3</th>'' +
N''<th>Col4</th>'' +
N''<th>Col5</th>'' +
N''<th>Col6</th>'' +
N''<th>Col7</th>'' +
N''<th>Col8</th>'' +
N''<th>Col9</th>'' +
N''<th>Col10</th>'' +
N''<th>Col11</th>'' +
N''<th>Col12</th>'' +
N''<th>Col13</th>'' +
N''<th>Col14</th>'' +
N''<th>Col15</th>'' +
N''<th>Col16</th>'' +
N''</tr>'' +
CAST ( ( SELECT td=[servername],''''
,td=[dbname],''''
,td=[OverlappingIndex],''''
,td=[Col1],''''
,td=[Col2],''''
,td=[Col3],''''
,td=[Col4],''''
,td=[Col5],''''
,td=[Col6],''''
,td=[Col7],''''
,td=[Col8],''''
,td=[Col9],''''
,td=[Col10],''''
,td=[Col11],''''
,td=[Col12],''''
,td=[Col13],''''
,td=[Col14],''''
,td=[Col15],''''
,td=[Col16],''''
FROM DBA_Monitoring.dbo.IndexOverview_DuplicateIndex
ORDER BY
	ServerName, DBName, TableName,IndexName
FOR XML PATH(''tr''), TYPE
) AS NVARCHAR(MAX) ) +
N''</table>'' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = ''<add your mail profile>'',
@recipients = ''<add your email>'',
@subject = @Subject,
@body = @tableHTML,
@body_format = ''HTML'' ;

END', 
		@database_name=N'DBA_Monitoring', 
		@output_file_name=N'<add your path>\IndexOverviewErrors.txt', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [report - missing index]      ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'report - missing index', 
		@step_id=4, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject=''SQL Server - Index Overview_Missing Index ''''Add Server Name''''''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM DBA_Monitoring.dbo.IndexOverview_MissingIndex
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N''<table border="1">'' +
N''<tr>'' +
N''<th>Server Name</th>'' +
N''<th>DB Name</th>'' +
N''<th>Avg Estimated Impact (milliseconds)</th>'' +
N''<th>Last User Seek</th>'' +
N''<th>Table Name</th>'' +
N''<th>Create Statement</th>'' +
N''</tr>'' +
CAST ( ( SELECT td=[ServerName],''''
,td=[DBname],''''
,td=Cast([Avg_Estimated_Impact] as varchar(25)),''''
,td=[Last_User_Seek],''''
,td=[TableName],''''
,td=[Create_Statement],''''
FROM DBA_Monitoring.dbo.IndexOverview_MissingIndex
order by ServerName, DBName, TableName
FOR XML PATH(''tr''), TYPE
) AS NVARCHAR(MAX) ) +
N''</table>'' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = ''<add your mail profile>'',
@recipients = ''<add your email>'',
@subject = @Subject,
@body = @tableHTML,
@body_format = ''HTML'' ;

END', 
		@database_name=N'DBA_Monitoring', 
		@output_file_name=N'<add your path>\IndexOverviewErrors.txt', 
		@flags=2
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [report- unused index]      ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'report- unused index', 
		@step_id=5, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject=''SQL Server - Index Overview_Unused Index ''''Add Server Name''''''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM DBA_Monitoring.dbo.IndexOverview_UnusedIndex
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N''<table border="1">'' +
N''<tr>'' +
N''<th>Server Name</th>'' +
N''<th>DB Name</th>'' +
N''<th>Object Name</th>'' +
N''<th>Index Name</th>'' +
N''<th>User Seek</th>'' +
N''<th>User Scan</th>'' +
N''<th>User Lookups</th>'' +
N''<th>User Updates</th>'' +
N''<th>Table Rows</th>'' +
N''<th>Drop Statement</th>'' +
N''</tr>'' +
CAST ( ( SELECT td=[ServerName],''''
,td=[DBname],''''
,td=[ObjectName],''''
,td=[IndexName],''''
,td=[USERSeek],''''
,td=[UserScans],''''
,td=[UserLookups],''''
,td=[UserUpdates],''''
,td=[TableRows],''''
,td=[drop statement],''''
FROM DBA_Monitoring.dbo.IndexOverview_UnusedIndex
order by ServerName, DBName, IndexName
FOR XML PATH(''tr''), TYPE
) AS NVARCHAR(MAX) ) +
N''</table>'' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = ''<add your mail profile>'',
@recipients = ''<add your email>'',
@subject = @Subject,
@body = @tableHTML,
@body_format = ''HTML'' ;

END', 
		@database_name=N'DBA_Monitoring', 
		@output_file_name=N'<add your path>\IndexOverviewErrors.txt', 
		@flags=2
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [report  - longest running queries]      ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'report  - longest running queries', 
		@step_id=6, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject=''SQL Server - Index Overview_Longest Running Queries ''''Add Server Name''''''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM DBA_Monitoring.dbo.IndexOverview_LongestQueries
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N''<table border="1">'' +
N''<tr>'' +
N''<th>Server Name</th>'' +
N''<th>DB Name</th>'' +
N''<th>Query Name</th>'' +
N''<th>Execution Count</th>'' +
N''<th>Max Elasped Time (milliseconds)</th>'' +
N''<th>Avg Elsaped Time (milliseconds)</th>'' +
N''</tr>'' +
CAST ( ( SELECT td=[ServerName],''''
,td=[DBname],''''
,td=[Queryname],''''
,td=[ExecutionCount],''''
,td=MaxElapsedTime,''''
,td=AvgElapsedTime,''''
FROM DBA_Monitoring.dbo.IndexOverview_LongestQueries
order by ServerName, DBName, QueryName, ExecutionCount
FOR XML PATH(''tr''), TYPE
) AS NVARCHAR(MAX) ) +
N''</table>'' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = ''<add your mail profile>'',
@recipients = ''<add your email>'',
@subject = @Subject,
@body = @tableHTML,
@body_format = ''HTML'' ;

END', 
		@database_name=N'DBA_Monitoring', 
		@output_file_name=N'<add your path>\IndexOverviewErrors.txt', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [report - index read counts]      ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'report - index read counts', 
		@step_id=7, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject=''SQL Server - Index Overview_Index Reads with Counts ''''<Add Server/Database Names>''''''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM DBA_Monitoring.dbo.IndexOverviewReadsWithCounts
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N''<table border="1">'' +
N''<tr>'' +
N''<th>Server Name</th>'' +
N''<th>DB Name</th>'' +
N''<th>Object</th>'' +
N''<th>Execution Count</th>'' +
N''<th>Total Logical Reads</th>'' +
N''<th>Total Physical Reads</th>'' +
N''</tr>'' +
CAST ( ( SELECT td=[ServerName],''''
,td=[DataBase],''''
,td=[Object],''''
,td=[execution_count],''''
,td=total_logical_reads,''''
,td=total_physical_reads,''''
FROM DBA_Monitoring.dbo.IndexOverviewReadsWithCounts
order by ServerName, [Database], [Object]
FOR XML PATH(''tr''), TYPE
) AS NVARCHAR(MAX) ) +
N''</table>'' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = ''<add your mail profile here>'',
@recipients = ''<add your email here>'',
@subject = @Subject,
@body = @tableHTML,
@body_format = ''HTML'' ;

END', 
		@database_name=N'DBA_Monitoring', 
		@output_file_name=N'<add your path>\IndexOverviewErrors.txt', 
		@flags=2
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [report - index read statements]      ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'report - index read statements', 
		@step_id=8, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject=''SQL Server - Index Overview_Index Reads with Statements ''''<Add Server/Database Names>''''''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM DBA_Monitoring.dbo.IndexOverviewReadsWithQuery
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N''<table border="1">'' +
N''<tr>'' +
N''<th>Server Name</th>'' +
N''<th>DB Name</th>'' +
N''<th>Object</th>'' +
N''<th>Execution Count</th>'' +
N''<th>Total Logical Reads</th>'' +
N''<th>Total Physical Reads</th>'' +
N''<th>Statement</th>'' +
N''</tr>'' +
CAST ( ( SELECT top 100 td=[ServerName],''''
,td=[DataBase],''''
,td=[Object],''''
,td=[execution_count],''''
,td=total_logical_reads,''''
,td=total_physical_reads,''''
,td=[Statement],''''
FROM DBA_Monitoring.dbo.IndexOverviewReadsWithQuery
order by ServerName, [Database], [Object]
FOR XML PATH(''tr''), TYPE
) AS NVARCHAR(MAX) ) +
N''</table>'' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = ''<add your mail profile here>'',
@recipients = ''<add your email here>'',
@subject = @Subject,
@body = @tableHTML,
@body_format = ''HTML'' ;

END', 
		@database_name=N'DBA_Monitoring', 
		@output_file_name=N'<add your path>\IndexOverviewErrors.txt', 
		@flags=2
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [report - fragmentation levels]      ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'report - fragmentation levels', 
		@step_id=9, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject=''SQL Server - Index Overview_Fragmentation Levels ''''Add Server Name''''''

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM DBA_Monitoring.dbo.IndexOverview_FragLevels
PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N''<table border="1">'' +
N''<tr>'' +
N''<th>Server Name</th>'' +
N''<th>DB Name</th>'' +
N''<th>Table</th>'' +
N''<th>Index</th>'' +
N''<th>Fragmentation %</th>'' +
N''<th>Page Count</th>'' +
N''</tr>'' +
CAST ( ( SELECT td=[ServerName],''''
,td=[DBname],''''
,td=[Table],''''
,td=IsNull([Index], ''HEAP - no clustered index''),''''
,td=convert(varchar, round([avg_fragmentation_in_percent], 2)),''''
,td=[page_count],''''
FROM DBA_Monitoring.dbo.IndexOverview_FragLevels
order by ServerName, DBName, [Table], [Index]
FOR XML PATH(''tr''), TYPE
) AS NVARCHAR(MAX) ) +
N''</table>'' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = ''<add your mail profile>'',
@recipients = ''<add your email>'',
@subject = @Subject,
@body = @tableHTML,
@body_format = ''HTML'' ;

END', 
		@database_name=N'DBA_Monitoring', 
		@output_file_name=N'<add your path>\IndexOverviewErrors.txt', 
		@flags=2
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:

GO


